interior_y_dim = 100;
interior_x_dim = 100+13;
wall_thickness = 2;
base_thickness = 2;
$fn = 12;

board_thickness = 2.0;

outer_x_dim = wall_thickness * 2 + interior_x_dim;
outer_y_dim = wall_thickness * 2 + interior_y_dim;

post_radius = 4;
post_hole_radius = 1.5;
post_height = 3;

//mounts are 79 x 85
board_hole_y_spacing = 85;
board_hole_x_spacing = 79;
// pcb mount post
pcb_y_offset = 7;
pcb_x_offset = 20;

interior_height = 30;
exterior_height = base_thickness + interior_height;

holes_radius = 5;
cutout_size = 6.5;
// base
difference(){
cube([outer_x_dim,outer_y_dim, base_thickness]);
    translate([pcb_x_offset + post_radius +2 ,wall_thickness * 2 + 2  , -1]){
    union(){
        for(x_disp = [0:7])
            for(y_disp = [0:9])
            if (x_disp % 2 == 1) {
            translate([x_disp*(base_thickness + cutout_size), (cutout_size/2.0) + base_thickness/2.0 + y_disp * (base_thickness+cutout_size), 0]){
              
                cube([cutout_size,cutout_size,10]);
            };  
            }else{
            translate([x_disp*(base_thickness + cutout_size), y_disp * (base_thickness + cutout_size), 0]){
              
                cube([cutout_size,cutout_size,10]);
            };  
            }
              
            
    }
   }

}
/**
fan_radius = 25;
fan_offset = 30;
fan_hole_spacing = 50;
translate([-1*145,0,0]){
  difference(){
      union(){
      cube([outer_x_dim, outer_y_dim, base_thickness]);
        
      translate([wall_thickness, wall_thickness, base_thickness]){
          
        color("red") cube([outer_x_dim, outer_y_dim, 2]);    
      }
    }
    union(){
        translate([fan_radius+fan_offset,fan_radius+fan_offset,-1]){
          cylinder(h = base_thickness * 2 + 2, r= fan_radius);
        
          }  
        }
        translate([fan_offset, fan_offset -1]){
          cylinder(h = base_thickness * 2 + 2, r = 4);
        }
        translate([fan_offset + fan_hole_spacing, fan_offset -1]){
          cylinder(h = base_thickness * 2 + 2, r = 4);
        }
        translate([fan_offset, fan_offset -1 + fan_hole_spacing]){
          cylinder(h = base_thickness * 2 + 2, r = 4);
        }
        translate([fan_offset+ fan_hole_spacing, fan_offset -1 + fan_hole_spacing]){
          cylinder(h = base_thickness * 2 + 2, r = 4);
        }
        // hole for wires
        
        translate([fan_offset + 15, fan_offset -10 ]){
          cylinder(h = base_thickness * 2 + 2, r = 2.5);
        }
   }
}
**/

// pcb mount post
translate([pcb_x_offset+board_hole_x_spacing,pcb_y_offset,3]){    
  difference(){    
    color("Blue") cylinder(h=post_height, r=post_radius);
    cylinder(h=post_height+1, r=post_hole_radius);
  }
}
// pcb mount post
translate([pcb_x_offset+board_hole_x_spacing, pcb_y_offset + board_hole_y_spacing,base_thickness]){    
  difference(){    
    color("Blue") cylinder(h=post_height, r=post_radius);
    cylinder(h=post_height+1, r=post_hole_radius);
  }
}
// pcb mount post
translate([pcb_x_offset,pcb_y_offset + board_hole_y_spacing,base_thickness]){    
  difference(){    
    color("Blue") cylinder(h=post_height, r=post_radius);
    cylinder(h=post_height+1, r=post_hole_radius);
  }
}

// pcb mount post
translate([pcb_x_offset,pcb_y_offset,base_thickness]){
  difference(){    
    color("Blue") cylinder(h=post_height, r=post_radius);
    cylinder(h=post_height+1, r=post_hole_radius);
  }
}


//wall
difference() {
  color("green") cube([wall_thickness,outer_y_dim, exterior_height]);
    // cutout for cables at the top
  translate([-1,10,6]){
    cube([5, 85, exterior_height]);
  };
}

//wall
difference() {
cube([outer_x_dim, wall_thickness, exterior_height]);
// USB connector - 60mm from top left mounting hole
translate([pcb_x_offset + 60,-1,3+2]) {
  cube([14,12,13]);    
}
// power connector - 32mm from top left mounting hole
translate([pcb_x_offset + 36,-1,3+4]) {
  cube([12,10,12]);    
}
}

//wall
translate([wall_thickness + interior_x_dim,0,0]){
  difference() {
  cube([wall_thickness, outer_y_dim, exterior_height]);  
  // pass through for optional
      // LCD cable
      translate([-1,12,exterior_height - 5]){
        cube([5,23,6]);
      }
  }
}

//wall
translate([0,wall_thickness + interior_y_dim,0]){
  difference() {
  cube([outer_x_dim, wall_thickness, exterior_height]);  
      // hole for extra cables
      translate([75,10,6+post_height+board_thickness]){
        rotate([90,0,0]){
          cylinder(r = 6, h = 11);
        }
      };
  }
}

tab_thickness = 4;
mounting_tab_hole_diameter = 5.75;

// mounting tab
translate([outer_x_dim,4,0]){    
    
   difference(){
      color("Red") minkowski(){
          cube([10,10, tab_thickness]); 
          cylinder(r=1, h =0.1);
      }
          translate([5,5,-1]){
            cylinder(h= 10, r = mounting_tab_hole_diameter/2.0);
          }
      }
      

}

// mounting tab
translate([outer_x_dim,91,0]){
  difference(){
  color("Red") minkowski(){
          cube([10,10, tab_thickness]); 
          cylinder(r=1, h =0.1);
      }
      translate([5,5,-1]){
        cylinder(h= 10, r = mounting_tab_hole_diameter/2.0);
      }
  }  
}

// mounting tab
translate([-10,outer_y_dim-89-10,0]){
  difference(){
  color("Red") minkowski(){
          cube([10,10, tab_thickness]); 
          cylinder(r=1, h =0.1);
      }
      translate([5,5,-1]){
        cylinder(h= 10, r = mounting_tab_hole_diameter/2.0);
      }
  }
};

//cover mounting tabs
cover_tab_dim = 8;
cover_tab_thickness = 2;
cover_tab_support_layer_height = 1.2;
cover_tab_offset = 10;
module cover_tab() {
    union(){
          difference(){
              union(){
                  minkowski(){
                     cube([cover_tab_dim, cover_tab_dim,cover_tab_thickness]);
                      cylinder(r=1, h=0.1);
                  }
                  translate([0,0, -1 * ( cover_tab_support_height)]){
                      for(z_disp = [0:6]){            
                            translate([0,0.5 + z_disp*cover_tab_support_layer_height,-1 * (cover_tab_support_layer_height *(1+z_disp))]){
                                color("Red") minkowski(){
                                   cube([cover_tab_dim,(cover_tab_dim - z_disp*cover_tab_support_layer_height), cover_tab_support_layer_height]);
                                   cylinder(r = 1, h =0.1);
                                }
                            }            
                      }        
                    }
              }
              translate([cover_tab_dim/2.0,cover_tab_dim/2.0,cover_tab_thickness * -1.5]){
                cylinder(r = post_hole_radius , h = cover_tab_thickness * 3.5);
              }
          }
            
        };
    }


function hadamard(a,b) = !(len(a)>0) ? a*b : [ for(i = [0:len(a)-1]) hadamard(a[i],b[i]) ];
for( i = [ 
[ cover_tab_offset, -1, 1],   
[ cover_tab_offset + 90 , -1, 1],
]) {
    translate(hadamard(i,[1, cover_tab_dim, exterior_height - cover_tab_thickness]) ){
        cover_tab();
        
        translate([cover_tab_dim, cover_tab_dim*2 + outer_y_dim,0]){
            rotate([0,0,-180]){
                cover_tab();
            }
        }
        
    }
}




