make_male = false;
make_female = false;
// 1/2 PVC is nominally an OD of 0.840
// However the actual tube is non round and has a dimension of up to 0.860
pipe_dia = 25.4 * 0.860;

bolt_dia = 0.2660 * 25.4; 

pivot_disc_dia = pipe_dia * 2.2; // I just made this up. 
pivot_disc_thickness = 4.1;
pivot_disc_circumfrence = 3.14 * pivot_disc_dia;
bolt_head_thickness = 10/64 * 25.4;
hexagon_short_to_long_diameter = 1.1547;
bolt_head_dia = 7/16.0 * 25.4 * hexagon_short_to_long_diameter * 1.05;
$fn = 40;

notch_count = 16;
notch_width = pivot_disc_circumfrence/(notch_count*2);
mount_length = pivot_disc_dia/2 + pipe_dia * 1.5;
mount_thickness = pivot_disc_thickness - 0.1;

mount_width = pipe_dia * 1.52;

// original value is 12/64 inches
pipe_screw_dia = 12/64.0 * 25.4; 
notch_height = 1.5;

washer_mount_thickness = 1.5;

module notches(height_margin, inner_cyclinder_fraction, notch_width_delta, notch_length_delta) {  
  cylinder(r = pivot_disc_dia/2 * notch_percentage * inner_cyclinder_fraction, h = pivot_disc_thickness+ height_margin);            
  
    for(x=[0:notch_count]){
      rotate([0,0,360/notch_count * (x)]){
        translate([0,(notch_width - notch_width_delta)/-2,0]){
          cube([pivot_disc_dia/2  + notch_length_delta, notch_width - notch_width_delta, notch_height + height_margin]);
      }
    }
  }
}

notch_percentage = 0.70;


module mount(){
  difference(){
    union(){
      translate([pivot_disc_dia/2 + 2.5,0,0]){
        difference(){
          translate([0,0,mount_thickness/2]){
            scale([1,1,1.7]){
              rotate([0,90,0]){        
                cylinder(r = mount_width/2, h = mount_length - pivot_disc_dia/2 - 2.5 );
              }
            }
          }
          translate([pivot_disc_thickness, 0, mount_thickness + pipe_dia/2 + 0.77]){
            rotate([0,90,0]){
              cylinder( r= pipe_dia/2 + 0.1, h = mount_length - pivot_disc_dia/2 - 2.5);
            }            
          }
          translate([-3.0,0,mount_thickness + pipe_dia/2 + 0.77]){
            rotate([0,90,0]){
              cylinder( r= pipe_dia/3, h = 10);
            }            
          }
          translate([-1,mount_width/-2,1.81 * mount_width/2 * -1]){
            cube([mount_length,mount_width,1.81 * mount_width/2]);
          }
        }
      }
      translate([bolt_head_dia,mount_width/-2,0]){
        cube([mount_length - bolt_head_dia,mount_width, mount_thickness]);        
      }

     
      translate([mount_length,0,0]){
        scale([0.7,1,1]){
          cylinder(r = mount_width/2.0, h = mount_thickness);
        }
  }
}

union(){
  translate([pivot_disc_dia/2  +2.5 + pipe_dia * 0.75,0, -3.0]){
    translate([-3,0,0]){
      cylinder(r = pipe_screw_dia/2, h = mount_thickness* 2 + 3.1);
    }
    
    translate([0,0,pipe_dia/2.0 + 3.0]){
      translate([3,0,0]){
        rotate([60,0,0]){
          cylinder(r = pipe_screw_dia/2, h = pipe_dia);
        }
      }
      rotate([-60,0,0]){
        cylinder(r = pipe_screw_dia/2, h = pipe_dia);
      }
    }
  }
}
}
}



if(make_male){
union(){
  difference(){
    cylinder(r = pivot_disc_dia/2, h = pivot_disc_thickness);
    union(){
      translate([0,0,-3.0]){
        cylinder(r = bolt_dia/2, h = pivot_disc_thickness * 2 + 3.1);                
      }      
    }
  }

  color("green"){
    translate([0,0,pivot_disc_thickness]){
      difference(){
        cylinder(r = pivot_disc_dia/2, h = notch_height);
        union() {          
          translate([0,0,-3.0]){            
            notches(3.2, 1.0,0.0, 1);
          }          
        }
      }
    }
  }
  
  mount();
}
}

if (make_female) {
translate([0,0,pivot_disc_thickness *5]){
  union(){
    difference(){
      union(){
        translate([0,0,-1 * notch_height]){
        difference(){      
            cylinder( r = pivot_disc_dia/2 + 1.5, h =notch_height  + pivot_disc_thickness);     
          translate([0,0,-3.0]){
            cylinder(r = pivot_disc_dia/2 + 0.5, h = notch_height + 3.1);
        }             
        }
      }
        translate([0,0,notch_height * -1]){
          color("red") notches(0,0.98,0.16, 1);
        }
        

      }
          translate([0,0,-2 * pivot_disc_thickness + 3.0]){
        cylinder(r = bolt_dia/2, h = pivot_disc_thickness * 2 + 3.1);
      }
    }
    translate([0,0,pivot_disc_thickness]){
      rotate([180,0,90]){
        mount();
      }
    }
  }
}
}



/**
translate([pivot_disc_dia * -1, 0, 0]){
  difference(){
  cylinder(r = bolt_head_dia/2 * 1.4, h = bolt_head_thickness + washer_mount_thickness);
    union(){
    translate([0,0,washer_mount_thickness]){
    cylinder( r = bolt_head_dia/2, h = bolt_head_thickness + 3.1, $fn=6);
    }
    translate([0,0,-3.0]){
      cylinder(r = bolt_dia/2, h = pivot_disc_thickness * 2 + 3.1);                
      }
  }
  }
}
**/
